<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Importer;

$importer = Importer::instance();
$verified = $importer->is_envato_verified();

?>

<form method="post" autocomplete="off">
    <div class="ulz-panel ulz-outer ulz-loading" id="ulz-panel" data-tab-start="general/units" :class="{ 'ulz-ready' : ready }">
        <div class="ulz-section ulz-import">

            <h3 class="ulz-import-title"><?php esc_html_e( 'Demo import', 'utillz-core' ); ?></h3>
            <p><?php esc_html_e( 'Select a demo and click the import button. While importing the demo content, it is very important to not reload the page of turn off your compoter. Otherwise the import may be processed partially. The process may take several minutes, depending on your internet connection.', 'utillz-core' ); ?></p>

            <?php if( get_option( 'ulz_is_demo_imported' ) ): ?>
                <div class="ulz--success">
                    <div class="ulz--content">
                        <?php esc_html_e( 'The demo content has been imported successfully', 'utillz-core' ); ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="ulz--system">
                <h4 class="ulz--title"><?php esc_html_e( 'Recommended server stats', 'utillz-core' ); ?>:</h4>

                <table class="ulz-table ulz--table-system">
                    <thead>
                        <tr>
                            <th width="40"><?php esc_html_e('Stats', 'utillz-core'); ?></th>
                            <th width="30"><?php esc_html_e('Recommended', 'utillz-core'); ?></th>
                            <th width="30"><?php esc_html_e('System', 'utillz-core'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach( $importer->system as $system ): ?>
                            <?php $passed = boolval( (int) $system['state'] >= (int) $system['recommended'] || (int) $system['state'] == 0 ); ?>
                            <tr>
                                <td><code><?php echo esc_html( $system['id'] ); ?></code></td>
                                <td>>= <?php echo esc_html( $system['recommended'] ); ?></td>
                                <td><?php echo esc_html( $system['state'] ); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <?php $demos = $importer->get_demos(); ?>
            <?php if( $demos ): ?>
                <h2 class="ulz--title"><?php esc_html_e( 'Select demo', 'utillz-core' ); ?>:</h2>
                <div class="ulz-demos">
                    <ul>
                        <?php foreach( $demos as $key => $demo ): ?>
                            <li>
                                <label>
                                    <input type="radio" name="demo" value="<?php echo esc_attr( $key ); ?>">
                                    <div class='ulz--image ulz-no-select'>
                                        <div class="ulz--img">
                                            <img src="<?php echo esc_url( $demo['thumbnail'] ); ?>" alt="">
                                        </div>
                                        <span><?php echo esc_html( $demo['name'] ); ?></span>
                                        <i><?php esc_html_e( 'Selected', 'utillz-core' ); ?></i>
                                    </div>
                                </label>
                            </li>
                        <?php endforeach; ?>
                    </ul>

                    <?php if( ! $verified ): ?>
                        <div class="ulz-notice ulz-notice-alert ulz-mb-3">
                            <i class="fas fa-bell ulz-mr-1"></i>
                            <?php esc_html_e( 'Please verify your ownership using the Envato Market plugin in order to enable the demo importer', 'utillz-core' ); ?>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="">
                    <?php if( $verified ): ?>
                        <a href="#" class="ulz-button ulz--large" data-action="import-demos">
                            <span><?php esc_html_e( 'Import demo', 'utillz-core' ); ?></span>
                            <?php Ucore()->preloader(); ?>
                        </a>
                    <?php else: ?>
                        <a href="#" class="ulz-button ulz--large ulz--mutted">
                            <span><?php esc_html_e( 'Import demo', 'utillz-core' ); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <p><?php esc_html_e( 'No demos are available', 'utillz-core' ); ?></p>
            <?php endif; ?>

        </div>
    </div>
</form>

<span class="ulz-importer-overlay"></span>

<div class="ulz-importer-progress">
    <div class="ulz--title">
        <?php Ucore()->preloader(); ?>
        <span><?php esc_html_e( 'Preparing import', 'utillz-core' ); ?></span>
    </div>
    <div class="ulz--progress">
        <span class="ulz--bar"></span>
    </div>
    <div class="ulz--ready">
        <a href="<?php echo get_dashboard_url(); ?>" class="ulz-button"><?php esc_html_e( 'Go to dashboard', 'utillz-core' ); ?></a>
    </div>
</div>
